using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgSelectPatientOrder
	/// </summary>
	public class DlgSelectPatientOrder : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.OrderReport _report;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.PatientOrderSelectorForReport patientOrderSelectorForReport1;

		#region constructor

		/// <summary>
		/// Cosntrcutor
		/// </summary>
		/// <param name="orderReport"></param>
		public DlgSelectPatientOrder(BOL.OrderReport orderReport)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			_report = orderReport;
			_report.IsSingleOrderReport = true;

			SetComponentProperties();
		}

		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.patientOrderSelectorForReport1 = new gov.va.med.vbecs.GUI.controls.PatientOrderSelectorForReport();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(732, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Select Patient Order";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(574, 441);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(654, 441);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// patientOrderSelectorForReport1
			// 
			this.patientOrderSelectorForReport1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientOrderSelectorForReport1.EnabledBloodAvailButton = false;
			this.patientOrderSelectorForReport1.EnabledMedicationButton = false;
			this.patientOrderSelectorForReport1.EnabledRecentOrdersButton = false;
			this.patientOrderSelectorForReport1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientOrderSelectorForReport1.EnabledSIAndTRButton = false;
			this.patientOrderSelectorForReport1.EnabledTransfusionReactionHistoryButton = false;
			this.patientOrderSelectorForReport1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientOrderSelectorForReport1.Location = new System.Drawing.Point(4, 32);
			this.patientOrderSelectorForReport1.Name = "patientOrderSelectorForReport1";
			this.patientOrderSelectorForReport1.OrderableTestId = 0;
			this.patientOrderSelectorForReport1.OrderedComponentGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientOrderSelectorForReport1.OrderedTestGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientOrderSelectorForReport1.OrderStatusCode = gov.va.med.vbecs.Common.OrderStatus.Accepted;
			this.patientOrderSelectorForReport1.PatientTreatmentGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientOrderSelectorForReport1.Size = new System.Drawing.Size(724, 401);
			this.patientOrderSelectorForReport1.TabIndex = 0;
			this.patientOrderSelectorForReport1.ItemDoubleClicked += new System.EventHandler(this.patientOrderSelectorForReport1_ItemDoubleClicked);
			this.patientOrderSelectorForReport1.ItemDeselected += new System.EventHandler(this.patientOrderSelectorForReport1_ItemDeselected);
			this.patientOrderSelectorForReport1.ItemSelected += new System.EventHandler(this.patientOrderSelectorForReport1_ItemSelected);
			// 
			// DlgSelectPatientOrder
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(732, 473);
			this.Controls.Add(this.patientOrderSelectorForReport1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Order_History_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(704, 500);
			this.Name = "DlgSelectPatientOrder";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Patient Order";
			this.Load += new System.EventHandler(this.DlgSelectPatientOrder_Load);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.patientOrderSelectorForReport1, 0);
			this.ResumeLayout(false);

		}
		#endregion


		#region properties
		
		/// <summary>
		/// Get CprsOrderNumber
		/// </summary>
		public string CprsOrderNumber
		{
			get
			{
				return this.patientOrderSelectorForReport1.CprsOrderNumber;
			}
		}

		/// <summary>
		/// Get OrderReport
		/// </summary>
		public BOL.OrderReport OrderReport
		{
			get
			{
				return _report;
			}
		}

		#endregion


		#region methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC086.DlgSelectPatientOrder());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
		}

		#endregion


		#region events

		private void DlgSelectPatientOrder_Load(object sender, System.EventArgs e)
		{
			this.patientOrderSelectorForReport1.SetControl();
		}


		/// <summary>
		/// BR_86.03
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void patientOrderSelectorForReport1_ItemSelected(object sender, System.EventArgs e)
		{
			if (patientOrderSelectorForReport1.OrderedComponentGuid != Guid.Empty)
			{
				_report.OrderGuid = patientOrderSelectorForReport1.OrderedComponentGuid;
				_report.IsComponentOrder = true;
			}
			else
			{
				_report.OrderGuid = patientOrderSelectorForReport1.OrderedTestGuid;
				_report.IsComponentOrder = false;
			}
			this.btnOK.EnabledButton = true;
		}

		private void patientOrderSelectorForReport1_ItemDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this._report.OrderGuid = Guid.Empty;
			this.Close();
		}

		private void patientOrderSelectorForReport1_ItemDoubleClicked(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		#endregion
	}
}

